using System;

class Program
{
    static void Main()
    {
        string line1 = Console.ReadLine();
        int n = int.Parse(line1);
        
        string line2 = Console.ReadLine();
        string[] xParts = line2.Split();
        long[] x = new long[n];
        for (int i = 0; i < n; i++)
            x[i] = long.Parse(xParts[i]);
        
        string line3 = Console.ReadLine();
        string[] hParts = line3.Split();
        long[] h = new long[n];
        for (int i = 0; i < n; i++)
            h[i] = long.Parse(hParts[i]);

        for (int i = 0; i < n; i++)
        {
            long best = long.MaxValue;

            for (int j = 0; j < n; j++)
            {
                if (j != i)
                {
                    if (h[j] >= h[i])
                    {
                        long dist = x[j] - x[i];
                        if (dist < 0) dist = -dist;
                        
                        if (dist < best)
                            best = dist;
                    }
                }
            }

            for (int j = 0; j < n - 1; j++)
            {
                long xa = x[j];
                long xb = x[j + 1];
                long ha = h[j];
                long hb = h[j + 1];
                
                long x1, x2, h1, h2;
                
                if (xa < xb)
                {
                    x1 = xa;
                    x2 = xb;
                    h1 = ha;
                    h2 = hb;
                }
                else
                {
                    x1 = xb;
                    x2 = xa;
                    h1 = hb;
                    h2 = ha;
                }

                long dx = x2 - x1;
                long h_peak_num = h1 + h2 + dx;
                long h_peak = h_peak_num / 2;

                if (h_peak < h[i])
                    continue;

                long peakNum = x1 + h1 + x2 - h2;

                long left_x = x1 + h1 - h[i];
                if (left_x >= x1 && 2 * left_x <= peakNum && left_x != x[i])
                {
                    long dist = left_x - x[i];
                    if (dist < 0) dist = -dist;
                    if (dist < best)
                        best = dist;
                }

                long right_x = x2 - h2 + h[i];
                if (right_x <= x2 && 2 * right_x >= peakNum && right_x != x[i])
                {
                    long dist = right_x - x[i];
                    if (dist < 0) dist = -dist;
                    if (dist < best)
                        best = dist;
                }

                long peak_x_times_2 = peakNum;
                long peak_x = peak_x_times_2 / 2;
                
                if (peak_x >= x1 && peak_x <= x2 && peak_x != x[i])
                {
                    long h_at_peak = h1 - (peak_x - x1);

                    if (h_at_peak >= h[i])
                    {
                        long dist = peak_x - x[i];
                        if (dist < 0) dist = -dist;
                        if (dist < best)
                            best = dist;
                    }
                }

                if (peakNum % 2 == 1)
                {
                    long peak_x_ceil = peak_x + 1;
                    if (peak_x_ceil >= x1 && peak_x_ceil <= x2 && peak_x_ceil != x[i])
                    {
                        long h_at_peak_ceil = h2 + (peak_x_ceil - x2);
                        
                        if (h_at_peak_ceil >= h[i])
                        {
                            long dist = peak_x_ceil - x[i];
                            if (dist < 0) dist = -dist;
                            if (dist < best)
                                best = dist;
                        }
                    }
                }

                if (x[i] > x1 && x[i] < x2)
                {
                    long h_at_i;
                    
                    if (2 * x[i] < peakNum)
                        h_at_i = h1 - (x[i] - x1);
                    else
                        h_at_i = h2 + (x[i] - x2);

                    if (h_at_i >= h[i])
                        best = 0;
                }
            }

            string output = best == long.MaxValue ? "-1" : best.ToString();
            Console.WriteLine(output);
        }
    }
}